
/** 
 * Copied from wcl.js setupTable method
 * Size table correctly 
 */
function hmc_setupTable(dataBodyEnc) {

   var dataBody = document.getElementById(dataBodyEnc);
   
   if ( dataBody.offsetHeight > 0 ) {
      var scrollPaneEnc = dataBody.getAttribute('SPID');
      var scrollPane = document.getElementById(scrollPaneEnc);
      var actionBarEnc = dataBody.getAttribute('ABID');
      var actionBar = document.getElementById(actionBarEnc);
      var offset = actionBar ? actionBar.offsetHeight : 0;
      var viewRows = dataBody.getAttribute('RPV');
      var numRows = dataBody.getAttribute('DR');
      
      scrollPane.style.height = offset + ((dataBody.offsetHeight / dataBody.rows.length) * Math.min(numRows, viewRows));

      if ( scrollPane.getAttribute('H1BID') )
         hmc_resizeDiv(scrollPaneEnc);
   }
   else {
      setTimeout("setupTable('" + dataBodyEnc + "')", 10);
   }
   
}

/** Copied from wcl.js resizeDiv
 * handles resize of div  
 */
function hmc_resizeDiv(divID) {
   var div = document.getElementById(divID);
   var headBody1   = document.getElementById(div.getAttribute('H1BID'));
   var table1Style = headBody1.parentNode.style; 
   var headBody2   = document.getElementById(div.getAttribute('H2BID'));
   var table2Style = headBody2.parentNode.style; 
   var cellCount   = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);

   table1Style.tableLayout = 'auto';
   table2Style.tableLayout = 'auto';

   var output = "";
   for ( var c = 0; c < cellCount; c++ ) {
      var head2 = headBody2.rows[0].cells[c];
      widths[c] = head2.width ? head2.width : head2.offsetWidth;
      output = output + c + " : " + head2.width + " : " + head2.offsetWidth + " :\n";
   }

   table1Style.tableLayout = 'fixed';
   table2Style.tableLayout = 'fixed';

   for ( var c = 0; c < cellCount; c++ ) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];
      head1.width = widths[c];
      head2.width = widths[c];
   }
}

